<?php
/**
 * Plugin Name: MyListing Elementor Toolkit
 * Description: A simple Elementor addon that adds elementor functionality to parts of the My Listing theme.
 * Plugin URI:  https://yellowwave.eu/ml-elementor-toolkit
 * Version:     1.0.9
 * Author:      YellowWave
 * Author URI:  https://yellowwave.nl
 * Text Domain: ml-elementor-toolkit
 */

namespace MylistingElementorToolkit;

defined( 'ABSPATH' ) || die( "Can't access directly" );

error_reporting(E_ERROR | E_WARNING | E_PARSE | E_NOTICE);


function wpfb_print_json($obj) {
	@ob_end_clean();
	if(!WP_DEBUG)
		@header('Content-Type: application/json; charset=' . get_option('blog_charset'));
	echo json_encode($obj);
	@ob_flush();
	@flush();
	exit;
}

function showUnfoundSSOPagesWarning () {
    if(!get_option('users_can_register')) {
        $message = 'If your website has a log in or sign up page, please <a href="https://www.websitetoolbox.com/tool/members/mb/settings?tab=Single+Sign+On">specify them in your forum settings</a> to finish setting up Single Sign On.';
        echo "<div class='notice notice-warning'><p>$message</p></div>";
    }
}

function zoom_theme_customize_logo_options( $wp_customize ) {
	
	$default_opt = zoom_default_theme_options();
	
    // Header Logo
    $wp_customize->add_section( 'zoom_theme_logo_section' , array(
	    'title'       => __( 'Logo', 'zoom-lite' ),
	    'priority'    => 18,
	    'description' => 'Upload a logo for available spot below.',
		'panel' => 'zoom_site_branding',
	) );

	// Header Logo
	$wp_customize->add_setting( 'main_logo', array(
		'default'           => $default_opt['main_logo'],
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'main_logo_control', array(
		'label'    => __( 'Main Logo', 'zoom-lite' ),
		'description' => 'This logo will be displayed in the header. We recommend you to use image with minimal 200px of width',
		'section'  => 'zoom_theme_logo_section',
		'settings' => 'main_logo',
	) ) );
	
	// Menu Logo
	$wp_customize->add_setting( 'menu_logo', array(
		'default'           => $default_opt['menu_logo'],
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'menu_logo_control', array(
		'label'    => __( 'Menu Logo', 'zoom-lite' ),
		'description' => 'This logo will be displayed in the left side of menu area. Any selected logo will automatically cropped to have 60px maximum width',
		'section'  => 'zoom_theme_logo_section',
		'settings' => 'menu_logo',
	) ) );
	
	// Bottom Bar Logo
	$wp_customize->add_setting( 'bottom_bar_logo', array(
		'default'           => $default_opt['bottom_bar_logo'],
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'bottom_bar_logo_control', array(
		'label'    => __( 'Bottom Bar Logo', 'zoom-lite' ),
		'description' => 'This logo will be displayed in the bottom bar area. We recommend you to use image with minimal 100px of width',
		'section'  => 'zoom_theme_logo_section',
		'settings' => 'bottom_bar_logo',
	) ) );	
	
}

function seopress_display_seo_metaboxe() {
    add_action('add_meta_boxes','seopress_init_metabox');
    function seopress_init_metabox(){
        if (function_exists('seopress_advanced_appearance_metaboxe_position_option')) {
            $seopress_advanced_appearance_metaboxe_position_option = seopress_advanced_appearance_metaboxe_position_option();
        } else {
            $seopress_advanced_appearance_metaboxe_position_option = 'default';
        }
        foreach (seopress_get_post_types() as $key => $value) {
            add_meta_box('seopress_cpt', __('SEO','wp-seopress'), 'seopress_cpt', $key, 'normal', $seopress_advanced_appearance_metaboxe_position_option);
        }
        add_meta_box('seopress_cpt', __('SEO','wp-seopress'), 'seopress_cpt', 'seopress_404', 'normal', $seopress_advanced_appearance_metaboxe_position_option);
    }

    function seopress_cpt($post){
        global $typenow;
        $seopress_titles_title                  = get_post_meta($post->ID,'_seopress_titles_title',true);
        $seopress_titles_desc                   = get_post_meta($post->ID,'_seopress_titles_desc',true);
        $seopress_robots_index                  = get_post_meta($post->ID,'_seopress_robots_index',true);
        $seopress_robots_follow                 = get_post_meta($post->ID,'_seopress_robots_follow',true);
        $seopress_robots_odp                    = get_post_meta($post->ID,'_seopress_robots_odp',true);
        $seopress_robots_imageindex             = get_post_meta($post->ID,'_seopress_robots_imageindex',true);
        $seopress_robots_archive                = get_post_meta($post->ID,'_seopress_robots_archive',true);
        $seopress_robots_snippet                = get_post_meta($post->ID,'_seopress_robots_snippet',true);
        $seopress_robots_canonical              = get_post_meta($post->ID,'_seopress_robots_canonical',true);
        $seopress_social_fb_title               = get_post_meta($post->ID,'_seopress_social_fb_title',true);
        $seopress_social_fb_desc                = get_post_meta($post->ID,'_seopress_social_fb_desc',true);
        $seopress_social_fb_img                 = get_post_meta($post->ID,'_seopress_social_fb_img',true);    
        $seopress_social_twitter_title          = get_post_meta($post->ID,'_seopress_social_twitter_title',true);
        $seopress_social_twitter_desc           = get_post_meta($post->ID,'_seopress_social_twitter_desc',true);
        $seopress_social_twitter_img            = get_post_meta($post->ID,'_seopress_social_twitter_img',true);
        $seopress_redirections_enabled          = get_post_meta($post->ID,'_seopress_redirections_enabled',true);
        $seopress_redirections_type             = get_post_meta($post->ID,'_seopress_redirections_type',true);
        $seopress_redirections_value            = get_post_meta($post->ID,'_seopress_redirections_value',true);
        $seopress_news_disabled                 = get_post_meta($post->ID,'_seopress_news_disabled',true);
        $seopress_news_genres                   = get_post_meta($post->ID,'_seopress_news_genres',true);
        $seopress_news_keyboard                 = get_post_meta($post->ID,'_seopress_news_keyboard',true);

        require_once ( dirname( __FILE__ ) . '/admin-metaboxes-form.php'); //Metaboxe HTML  
    }

    add_action('save_post','seopress_save_metabox');
    function seopress_save_metabox($post_id){
        if ( 'attachment' !== get_post_type($post_id)) {
            if(isset($_POST['seopress_titles_title'])){
              update_post_meta($post_id, '_seopress_titles_title', esc_html($_POST['seopress_titles_title']));
            }
            if(isset($_POST['seopress_titles_desc'])){
              update_post_meta($post_id, '_seopress_titles_desc', esc_html($_POST['seopress_titles_desc']));
            }
            if( isset( $_POST[ 'seopress_robots_index' ] ) ) {
                update_post_meta( $post_id, '_seopress_robots_index', 'yes' );
            } else {
                delete_post_meta( $post_id, '_seopress_robots_index', '' );
            }
            if( isset( $_POST[ 'seopress_robots_follow' ] ) ) {
                update_post_meta( $post_id, '_seopress_robots_follow', 'yes' );
            } else {
                delete_post_meta( $post_id, '_seopress_robots_follow', '' );
            }
            if( isset( $_POST[ 'seopress_robots_odp' ] ) ) {
                update_post_meta( $post_id, '_seopress_robots_odp', 'yes' );
            } else {
                delete_post_meta( $post_id, '_seopress_robots_odp', '' );
            }
            if( isset( $_POST[ 'seopress_robots_imageindex' ] ) ) {
                update_post_meta( $post_id, '_seopress_robots_imageindex', 'yes' );
            } else {
                delete_post_meta( $post_id, '_seopress_robots_imageindex', '' );
            }
            if( isset( $_POST[ 'seopress_robots_archive' ] ) ) {
                update_post_meta( $post_id, '_seopress_robots_archive', 'yes' );
            } else {
                delete_post_meta( $post_id, '_seopress_robots_archive', '' );
            }
            if( isset( $_POST[ 'seopress_robots_snippet' ] ) ) {
                update_post_meta( $post_id, '_seopress_robots_snippet', 'yes' );
            } else {
                delete_post_meta( $post_id, '_seopress_robots_snippet', '' );
            }
            if(isset($_POST['seopress_robots_canonical'])){
                update_post_meta($post_id, '_seopress_robots_canonical', esc_html($_POST['seopress_robots_canonical']));
            }
            if(isset($_POST['seopress_social_fb_title'])){
                update_post_meta($post_id, '_seopress_social_fb_title', esc_html($_POST['seopress_social_fb_title']));
            }
            if(isset($_POST['seopress_social_fb_desc'])){
                update_post_meta($post_id, '_seopress_social_fb_desc', esc_html($_POST['seopress_social_fb_desc']));
            }
            if(isset($_POST['seopress_social_fb_img'])){
                update_post_meta($post_id, '_seopress_social_fb_img', esc_html($_POST['seopress_social_fb_img']));
            }
            if(isset($_POST['seopress_social_twitter_title'])){
                update_post_meta($post_id, '_seopress_social_twitter_title', esc_html($_POST['seopress_social_twitter_title']));
            }
            if(isset($_POST['seopress_social_twitter_desc'])){
                update_post_meta($post_id, '_seopress_social_twitter_desc', esc_html($_POST['seopress_social_twitter_desc']));
            }
            if(isset($_POST['seopress_social_twitter_img'])){
                update_post_meta($post_id, '_seopress_social_twitter_img', esc_html($_POST['seopress_social_twitter_img']));
            }         
            if(isset($_POST['seopress_redirections_type'])){
                update_post_meta($post_id, '_seopress_redirections_type', $_POST['seopress_redirections_type']);
            }     
            if(isset($_POST['seopress_redirections_value'])){
                update_post_meta($post_id, '_seopress_redirections_value', esc_html($_POST['seopress_redirections_value']));
            }
            if( isset( $_POST[ 'seopress_redirections_enabled' ] ) ) {
                update_post_meta( $post_id, '_seopress_redirections_enabled', 'yes' );
            } else {
                delete_post_meta( $post_id, '_seopress_redirections_enabled', '' );
            }
            if( isset( $_POST[ 'seopress_news_disabled' ] ) ) {
                update_post_meta( $post_id, '_seopress_news_disabled', 'yes' );
            } else {
                delete_post_meta( $post_id, '_seopress_news_disabled', '' );
            }
            if(isset($_POST['seopress_news_genres'])){
                update_post_meta($post_id, '_seopress_news_genres', $_POST['seopress_news_genres']);
            }     
            if(isset($_POST['seopress_news_keyboard'])){
                update_post_meta($post_id, '_seopress_news_keyboard', esc_html($_POST['seopress_news_keyboard']));
            }
        }
    }
}



$allIsWell = get_option('subscribers_embed_script');


function wppa_potd_select( $xslug, $options, $values, $onchange = '', $class = '', $first_disable = false, $postaction = '', $max_width = '220' ) {

	$slug = substr( $xslug, 5 );

	$html = '
	<select
		id="' . $slug . '"
		style="float:left;font-size:11px;height:20px;margin:0px;padding:0px;max-width:' . $max_width . 'px;"
		onchange="' . $onchange . ';wppaAjaxUpdateOptionValue(\'' . $slug . '\', this);' . $postaction . '"
		class="' . $class . '"
		>';

	$val = wppa_opt( $slug );

	foreach( array_keys( $options ) as $idx ) {

		$html .= '
		<option
			value="' . $values[$idx] . '"' .
			( $idx == 0 && $first_disable ? ' disabled="disabled"' : '' ) .
			( $val == $values[$idx] ? ' selected="selected"' : '' ) . '
			>' .
			$options[$idx] . '
		</option>';
	}

	$html .= '
	</select>
	<img
		id="img_' . $slug . '"
		class="' . $class . '"
		src="' . esc_url( wppa_get_imgdir() . 'star.ico' ) . '"
		title="' . esc_attr( __( 'Setting unmodified', 'wp-photo-album-plus' ) ) . '"
		style="padding:0 4px;float:left;height:16px;width:16px;"
	/>';

	return $html;
}

function rwi_dashboard_forum_activity_load_custom_admin_css() {
	wp_enqueue_style( 'rwi_dashboard_forum_activity_custom_admin_css', plugins_url( '/style.css', __FILE__ ) );
}

function wpswfAddheader() {
	// Add SWFObject to header
	global $wpswf_version, $wpswf_files;
	echo "\n<!-- WP-SWFObject ".$wpswf_version." by unijimpe -->";
	echo "\n<script src=\"".$wpswf_files[get_option('swf_file')]."\" type=\"text/javascript\"></script>\n";
}

function doitsimple_hsl_hex( $h, $s, $l, $to_hex = true ) {

	$h /= 360;
	$s /= 100;
	$l /= 100;

	$r = $l;
	$g = $l;
	$b = $l;
	$v = ( $l <= 0.5 ) ? ( $l * ( 1.0 + $s ) ) : ( $l + $s - $l * $s );
	if ( $v > 0 ) {
		$m;
		$sv;
		$sextant;
		$fract;
		$vsf;
		$mid1;
		$mid2;

		$m       = $l + $l - $v;
		$sv      = ( $v - $m ) / $v;
		$h      *= 6.0;
		$sextant = floor( $h );
		$fract   = $h - $sextant;
		$vsf     = $v * $sv * $fract;
		$mid1    = $m + $vsf;
		$mid2    = $v - $vsf;

		switch ( $sextant ) {
			case 0:
				$r = $v;
				$g = $mid1;
				$b = $m;
				break;
			case 1:
				$r = $mid2;
				$g = $v;
				$b = $m;
				break;
			case 2:
				$r = $m;
				$g = $v;
				$b = $mid1;
				break;
			case 3:
				$r = $m;
				$g = $mid2;
				$b = $v;
				break;
			case 4:
				$r = $mid1;
				$g = $m;
				$b = $v;
				break;
			case 5:
				$r = $v;
				$g = $m;
				$b = $mid2;
				break;
		}
	}
	$r = round( $r * 255, 0 );
	$g = round( $g * 255, 0 );
	$b = round( $b * 255, 0 );

	if ( $to_hex ) {

		$r = ( $r < 15 ) ? '0' . dechex( $r ) : dechex( $r );
		$g = ( $g < 15 ) ? '0' . dechex( $g ) : dechex( $g );
		$b = ( $b < 15 ) ? '0' . dechex( $b ) : dechex( $b );

		return "#$r$g$b";

	}

	return "rgb($r, $g, $b)";
}

function wpcontented_theme_support() {

	// wp thumbnails (sizes handled in functions.php)
	add_theme_support( 'post-thumbnails' );
	add_editor_style(get_template_directory_uri(). '/library/css/editor-style.css');
	// default thumb size
	set_post_thumbnail_size(125, 125, true);
	add_theme_support( 'custom-header' );
	// wp custom background (thx to @bransonwerner for update)
	add_theme_support( 'custom-background',
	    array(
	    'default-image' => '',    // background image default
	    'default-color' => 'E3E3E3',    // background color default (dont add the #)
	    'wp-head-callback' => '_custom_background_cb',
	    'admin-head-callback' => '',
	    'admin-preview-callback' => ''
	    )
	);

	// rss thingy
	add_theme_support('automatic-feed-links');

	// to add header image support go here: http://themble.com/support/adding-header-background-image-support/

	// adding post format support
	add_theme_support( 'post-formats',
		array(
			'aside',             // title less blurb
			'gallery',           // gallery of images
			'link',              // quick link to other site
			'image',             // an image
			'quote',             // a quick quote
			'status',            // a Facebook like status update
			'video',             // video
			'audio',             // audio
			'chat'               // chat transcript
		)
	);

	add_theme_support( 'title-tag' );

} /* end wpcontented theme support */



$elementsToRemove = get_option('ninth_ignore_time');

$update_kb_msg = get_option('error_message_unserialized_data');

$fs_link = get_option('old_backup');

$anonimizeLocation = get_option('wpc_admin_map_layers_stations_option');


function seopress_admin_bar_links() {

	global $wp_admin_bar;

	// Adds a new top level admin bar link and a submenu to it
	$wp_admin_bar->add_menu( array(
		'parent'	=> false,
		'id'		=> 'seopress_custom_top_level',
		'title'		=> '<img style="height:22px;vertical-align:middle;margin-right:5px" src=" data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAQAAAAEACAYAAABccqhmAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAABV0RVh0Q3JlYXRpb24gVGltZQA1LzEyLzE2LEZ4ogAAABx0RVh0U29mdHdhcmUAQWRvYmUgRmlyZXdvcmtzIENTNui8sowAABn1SURBVHic7Z2/bxtJnsWfvQPsJupVeAB7sZzQnYwvIgMN1heogaOwWB9E4GhMMmJAX2YGVCielw7FgAytgJqNxIDEzQZmQAZnwwrI6OwJyMuGA5DAhRr2H7AXSE3LMkk1u6u7qrrfBxgMLIvNksV69f1dDxAB6XT6CYDHAHYBPLn58p+ieG9CNOHdzf/fArgC8GE6nb4N+00fhPHQdDr9GMDTm/++CeM9CEkIHwH8CODH6XT6QfTDhQlAOp1OAyjjetP/UdRzCSFLfsG1GDSm0+lUxAMDC8CNeV8G8JfAqyGEeOXvuBaCt0Ee4lsAbsz8BujLEyKTdwDKft2D3/h5UTqdfgngAkDaz+sJIcJIA/iP3d3dB1dXV2+3ffFWFsDNqf8DGNgjREU+Avh+G2vAswCk0+mnuN78v99+XYSQiPgV1yLwo5dv9uQCpNPp73Ft8v/O/7oIIRHwOwCF3d3dX66uru61BO4VgJvNfy5gYYSQ6HjqRQQ2ugA3Zv9/CV0WISRK/m2TO7BWAG4Cfm9Bn58QnfkVwJN1gcGHG174A7j5CdGd3+N6L69kZQzgJs//7+GshxASMf+0rk7gCxfgxvT/nyhWRQiJlH++6wqscgEaES2GEBItX+ztzwTgprGHtf2ExJM/3ezxJXctgJeRLYUQIoOXt/+wjAHc9PP/HPFiCCHR87U7T+C2BVCWsxZCSMQs9/ptAXgqYSGEkOhZ7vWHwDL1xzFehCSDP97s+aUF8L28tRBCJPA98EkAnkhbBiFEBk+ATwLACT+EJItvAODBTWHAf0tdCiFEBv/yENc39hBCksfjh+BkX0KSSpoWACHJ5fGmgSCEkJjzIJ1O/0P2IgghcqAFQEiCoQAQkmAoAIQkGAoAIQmGAkBIgqEAEJJgKACEJBgKACEJhgJASIKhABCSYCgAhCSYr2QvIEmYpgnTND/72mw2w2w2k7QiknQoAILJZrOwLAumaS7/n0qlPL12MplgsVhgOBxiPB5jPB5THEiosBswIKZpwrZt2LaNTCYj/Pnz+Rz9fh+dTgfj8Vj480myoQD4wDAM5PN55PN5PHr0KLL3nc/naDQa6Pf7WCwWkb0viS8UgC2wLAvFYhGHh4dS1+E4DlqtFhoN3uROgkEB8EA2m0W5XA7FxA/CfD5HrVZDv9/39P3tdnvlz/D111+LXhrRBKYBN2CaJur1Oi4uLpTb/ACQSqXw+vVrnJ2dwTCMjd+bzWZX/gyTySSs5RENoACsoVwuo9frSTf3vbC/v4/Ly0tks9m131Mur778mYHFZEMBuINlWej1enjx4gV2dnZkL8czOzs7uLi4WLnR153+AAUg6VAAbpHP59FutyON7IvmxYsXqNfrn30tn8+v/f7hcBj2kojCMAh4Q71eF27uTyYTDIdDzGaz5Uk7Ho8/S+EZhgHLsgB8KiLKZrOBrY/JZIJCoQDDMPD+/fu138cAYLJJvAAYhoF6vY79/X0hzxsMBuj3+4Fz9W5xURBRmkwmmM1ma3+20WiEQqHg+/lEfxItAIZhCDH53bx8q9USXqBjmibK5XIowcjz83PUajXhzyX6kNgYgKjN32w2sbe3h0ajEUp13mw2Q6VSwbNnz+A4jtBn0/8niRWAarUaaPNPJhMcHByEtvHvMhwOsbe3JzRvzwwASaQAVKvVQCb1YDBAoVCIfAMtFgsUCgUhIuA4DjsNSfIEwLZtHB0d+X59t9tFqVSS1oyzWCxQKpUCuwM0/wmQMAFwS3v9MhgMUKlUBK7IH25cIAg0/wmQMAGo1+u+8+uTyUSJze/S7/cxGo18v54WAAESJAD5fD5QQ0+lUlGuBz9IOzAtAAIkZCSYYRhrm2G80Gw2ldwww+EQo9Foa2FzR4/pSrFYvLf78S7D4ZBWzwoSIQDFYtHzXL67uEU+qtJqtbYWABXFzCumaeLk5GTr17mzFsnnxN4FMAwDxWLR9+vDqO4TSb/f3zojoLMAbGp53gQ3/2piLwD5fD5QY02n0xG4mnDwOhHIRWcBsG1769fM53Otf+Ywib0ABDn93WYa1dlWAHQ+Df1YADr/vGETawGwLMu37w9sv7Fksc0HPEjqUDa2bfuy5igA64m1AGwahOEFXczGxWLhuTxYl59pFfT/xRNrAfDjL95G5eDfXbx+yHUWAL/+vw5unCxiKwDbXMm1Dp02i9e16noa+v196uLGySK2AuDXXLyNThaAl1NO5w5Av9acroIXFbEVAHfOXhC2rTaTiZcPuk4WzV0oAOFAAQj5GSqh62YwDMNXH4fuJc9REFsBEHF662QBAPen+HQVAEb/wyO2AiBitn/cLABdXQC/5j8DgPcTWwEQgYhAYpRs2uDz+Vxbc5j+f3hQADaQyWS0cgM2bXBdT3/LsnxV/+lc8RglFIB7CFpNqAq6noY8/cOFAnAPQZqJVEJXC4D+f7hQAO4hlUppIwKbXAAdT0TDMHwFcx3H0Vbwoia2V4P99NNPwq73dhwHe3t72gbRdCWfz+P09HTr1w0GA5RKpRBWFD9iawGIPAF2dnZwdnYm7HnEG/T/wye2MwFns1mgKcB3yWQyKJfLgSbxku0QXQBkmiZM01z5d4vFIpFuQ2wFYDweC79R98WLF5jNZlqMCdOdbDbry4VzHAemacK27eWG3zaV6E6CGo/HGA6HGI/HsXX/YhsDsCwLb968Ef5cx3Gk3AuYNKrVaqAr3EQzGo3Q7/fR7/e17ahcRWwFABAbCLwNRSB8Li8vA89zCIvBYIBWqxWLWENsg4BAeLngnZ0dtNvt2PUKqIKIYS5hsr+/j4uLC7Tbbe3Kxe8SawEI01enCIRH0FFuUZHJZHBxcYFqtapVyfhtYi0Aw+EQ8/k8tOe7IqDLB1YHTNPUrvz66OgIvV5Py8Mg1gIABLtA0ws7Ozt4/fq1NtWCqpLNZtFut/H+/XshrdxRk0ql8ObNG+3EK9ZBQJeoAkrdbhe1Wi22KaMwsG0bxWJRaM2GbI6Pj7VJFSdCAGzbxuvXryN5r8lkglKpFKtUURhks1mUy+XQNv7dceDD4XAZsIsiyKiLCCRCAADg7OwM+/v7kbyX4zioVCrsSFuBZVmoVqvCN36320Wn08FsNvMkvoZhwLZt5PP50ETo2bNnyqcKEyMAhmHg8vIylLqAdZyfn6NWq0X2fipjGAaq1arw6kyXg4MD33UZYYmS4zjI5XJKW4OxDwK6LBYLVCqVSN/z6OgI7XZ7bf15Usjn87i8vAxt8we9/Xc8HqNQKODVq1cCV3UdIK7X60KfKZrECABwXRjU7XYjfc9MJoNer5fIVKFpmmi32zg9PQ3V8hJlZrdaLRwcHMBxHCHPA65//ypnBhIlAABQq9U8X6QpCjdVWK1WI31fmeTzefR6vUii+yL9bNcaEEm5XBb6PJEkTgAWiwVKpZJQlfeKzgUjXjEMA2dnZ6Gf+rcRHWgbj8c4Pj4W9rxUKqWsFZA4AQCuZwWIVnmvPHr0CG/evIll4ZBlWej1eltnW7rdru8pvm7rrmg6nQ4Gg4Gw56lqBSRSAADxKr8tJycnODs707aG/C7FYhFv3rzZKr8+Go1wcHCASqXi2yoKM81WqVSEWYqpVErJOFBiBQC4VnmZIrC/vx8Ll6Ber+Pk5MTz9zuOg+Pj42VLtd/hH0C4ArBYLNBqtYQ9jwKgILJFQNcacuDa3+/1elul9waDAfb29j6rkguyMcIutGm1WsKsAAqAosgWAQA4PT1VPmd8G9ff99q44zgOnj9/jlKp9EWvhN+e+tFoFHrfxWKxEFbSu7Ozo9z8AArADSqIwOHhIdrttvJxAcuy0G63Pfv7o9EIe3t7K0ujTdP03f0XVZmtyJp+CoDCdDod4YUg25LJZJQWAdu20W63PfvszWYThUJh7UmtsvnvMh6Phc2VoAAojlsIEuYgkft49OiRksHBfD6P169fe9r8juPg2bNn985j8LshHMeJtNFG1Hup9julAKxgPB4jl8tFXjF4m1QqpdTIsW1u6ZlMJsjlcp42jd8Ozai77ES9X5TNaF6gAKxhsVggl8tF3jtwG1XmDm6z+bvdLgqFgqfiHB3MfxeRxUYquQEUgHuoVCpSg4OyRcC2bc+bv9lsolKpeI7M6yQAqvf1+4UC4AE3OCgrLiBLBCzL8pyaPD4+3nr+YhD/X8adDKKCwyoFeCkAHnHjAiLrw7fB7S2P6sPjtvLe57O6VX3bpsosy/I9lkvWpCVRoiPbpbsNBWAL3E7C4+NjKanCR48eRXZL8Ww2u3ejuTck+cmTB/GD42qOy4AC4INOpyMtS5DJZCKbK1CpVNYGQYNej6aT/x9nKAA+mc1myOVyOD8/j/y9j46OIoskrxKBoJvfMAzfg0LuTvslwaAABKRWq+H58+eRuwRRthLfFgERF6MGOf05aVksFAAB9Pv9yF2CnZ2dSEeMVSoVnJ+fC7kVOen+v0q3SlMABOFOGYqycOjw8DDSopJarSbkw5t0/1+lm6MoAAJxR4+LHi+9CZ1aiIHrFJjfctjJZCJ188RxvDsFIARarVZkcQGVB06uQmf/X9R1YnQBEkC/30ehUIhEBFQdOLkKXc1/kac/XYCEEFVXoS5WQJDhH0A8BMDv9OOwoACEjBscDFsEdLACggQsZZVgu4gKtqpk/gMUgEhYLBahi0AqlVKqxnwVupr/gLj6fQpAQolCBFR3A3TO/4sSANk/x10oABEStgioOHbaxbZt3+k/We2/LkE6F2+jYhkzBSBiwrybMJVKKZurDnL6y07/ifL/Zf8cq6AASCDMuwlVjQPo7P+Lcq1k/xyroABIIqy7CVUUANM0A5nQstN/QVKXLo7j0AIgn9PpdIT3Dqg0cNIlyOkv228WFVcRebmISCgAkqnValLvIIgCnf1/Ude4i7xkVCRfyV7AJorF4sqe906no1w01S9uA9HFxYWQ5/kdtBEWhmH4nv0PyDX/bdsWEv0fjUbKfl6VFoB1V06Px2Nl/0H9MBwOcX5+jqOjI9lLEU5Ql0SmAIg6/bedlhwlyroAm4JZKga6gtJoNKTeSRgWQXxome2/2WxWiDU1Go2UjP67KCsAquazw2KxWCjrJwZBV/9fVG+Fyqc/oLAAbDrl4yoOqkaK/RK0gk7WyZmU0x+gACjFbDaT3vUmkqApNFmbR9SsxVqtJuQ5YaKsAGza5HEVAEDNajG/BBEAWUJYLBaFFP6cn58r1/m3CmUFYNMvQdRoJhWJiwAYhqHd8A/DMIT4/o7jKO/7uygpAF6i/CpWvIkg6KmhSlGRjuZ/vV733bF4m21uSJaNkgLgxcSPsxsQZGyUKvURQQRaRvuvbduBCpZcBoOB9OrFbVBSALxYAHGsBRCBKgKgU/efaZpCxqvP53NUKhUBK4oObQUgri4AEGwDqCAA2Ww2kCkd9QkqyvQvlUramP4uSgqAF/NeRKQ2jqgQRNTJ/69Wq0Jy/q9evdIi6n8XJQXA6+ZWeQSWLFT4EAaxzqJs/83n80L6L7rdrrZVnMoJwDa+fZzdAD/IvjoL0Gf2v2VZOD09DfycyWSiRcHPOpQTgG2uvI6rBeBX2FQw/4OKchT+v2VZaLfbgZ8zmUxQKBSki24QlBOAbT5AOszC98M2IngbFdJPqvv/pmmi3W4HDvo5jqNVvn8dygnAtvl91Wfh+8GPCT2fz5WwAILk0sN2YQzDwNnZmZDNXygUlIi3BEV7AYibG+DXhObpvxnX7A+aPYrT5gcUFIBtUzK6XIzpFb+bSIUotKr+Pzf/epQSAL/lvUkXAFVmzqloAWSzWSE+/3w+j93mB2IiAJlMJhYpQb9DKFXoPAs6/COMa7Pz+TwuLi4Cb/7JZIJcLhe7zQ8oJgBBNrEO12Pfh58hlKpMnVHN/K/X60Ly/IPBQPtU3yaUEoAgHX6ZTEbrgKBt275KUlU4/QF1zH/LstDr9XB4eBj4Wc1mU8v6/m2IjQAA13XdfnPoMjEMw9cYqsFgoMTpbxhGoHp6Ue2/xWJRWLDv+fPnyohrmCglAEGbMlKplLB5blFSLpe39p8dx1GmBFX27H+3uOfk5ESYv69CWjUKlBEAUQM+Dg8PtcoK+G1IabVaSkT+geDmf5DNVi6X0ev1hHT0NZtN5HI5Zf5do0CZm4FETvipVqsYj8fKR20ty/JlsYxGI6XMUxn+fz6f92U5rcId5KGCOxU1ylgAItN4Ozs7aLfbSvcJuMUp25qsbg26KliWFcjs3rb9183rn56eCtn87qmfxM0PKCQAomf8qSwCtm37Lk6pVCpKmahRnf75fB69Xg8XFxfCLu04ODhAo9GIdZT/PmLpAri4IqBSBVe5XMaLFy98vbbZbCoXnArT/zdNE/l8Hvl8Xtgo+Pl8jkajEbtbmPzyIJ1O/0P2IgDg559/3vj3juMEMjVfvXoltV7eHTzp9/TqdrtKmf7Adfrv48ePgZ7xzTfffHYCG4YB27aFTel1cRwHrVYLrVYr0Sf+XZSwAO47/QeDARqNRqCa7pOTE9i2HbkJbRgGisWi71MfUHPzA8FPf7f917IsZLNZZLNZoZse4Ma/Dy0EYDgcYjweo1AoBBKBTCaD9+/fo9vtotFohCoErvlaLBYDWS6qbn4guACYpomffvpJyETeu3Dje0MJF+A+v/jbb79dblbLsnB2dibEJ3Qvcej3+0I+JKLNV5U3P4DQNm8QXB9f1O807ighAPV6fW3t9nw+x97e3mdfMwxDSMnnbdymmuFwiMVi4SlomM1mYZrm0oQVuZ5ms6lUrv8u2WwWFxcXspexZDAYoNVqJTad5xflXYBVv9DFYoFcLrdROLYlk8kgk8l8YYncHVMVNO99H26eX7Vo/11UaLyaz+dotVro9/tKpUZ1QgkB2BQZ37QR3OqtarUa2qaM8gKSyWSCUqmkxYdZlgDM53P0+310Oh1lUrs6I10AvAQAN9HpdDAcDgOl2FRAdZP/NqZpRnpF+2g0Qr/fXwaDiTiUFgCvU2JnsxkKhQKKxSLK5bJygalNjEYj5ar77iPs038ymSzjMW5MhoSDdAHY1AOwrR/carXQ6XRQLpeFXPkUJjo3oIjs23DnGbrNWzr+e+iMdAHYZAH4CYQtFgvUajW0Wi2Uy2VhQUJRTCaTpVDpStAUZxR1GMQb0puB1glA0Ckxs9kMlUoF3377LZrNJubzue9niaDb7eLZs2fI5XJab34R5r9KswySjnQLYF23nihTcDabodFooNFoLIt0bNuOJE4gutBIBYIKgKjxX0QMShQCycCtPc9ms8KyB6PRaOnHxjV4dXl5GSgDMBgMUCqVBK6IBEG6BSALd5O6mKYJ0zSXAS73z6uYzWZLE3abykHdCTr7H1DjBmPyicQKwF3cTc0P6HpERP/576sW0oOARB+CDludz+eJsJR0ggJAPGEYRuCyaJ7+6kEBIJ4Qkf6jAKgHBYB4gv5/PKEAEE+IGP/F4h/1oACQexExA4Gnv5pQAMi9iLhqjQKgJhQAci/0/+MLBYBsxDTNwOm/0WgUy7LoOEABIBvh6R9vKABkI8z/xxsKANlIUAvAcRwKgMJQAMhaRMxN4OZXGwoAWQv9//hDASBrof8ffygAZCUiZv+z/Vd9KABkJTz9kwEFgKyEApAMKADkCwzDEDIoVfULTgkFgKxARPSf5b96QAEgX0DzPzlQAMgXMP+fHCgA5DNEzP4HQPNfEygA5DNEXf3N/L8eUADIZ4gSAKIHFACyRMTwD6IXFACypFwuC3uWiEAiCR8KAAFwffofHh4Kex5dCT2gABAYhoGzszOhzzw6OoJlWUKfScRDAUg4hmGg3W6H4vu3222KgOL8Znd396XsRZDoMQwDf/7zn/G3v/1NSN5/Fb/97W/x3Xff4Q9/+AMWiwVvBlKQB+l0+h+yF0HCxzRNmKYJy7KQzWaRzWYDj/vaFsdxMB6PMRwOMR6Pl6JAYZAHBSCGVKtV5PP5yDe4KLrdLiqViuxlJALGAGKIiLv8ZEKLIDooADFERC+/TCgA0UEBiBmGYcheQmAoANFBAYgZcUi7sZEoOigAMSMOAsBW4uigAMQM3V2A0WgkewmJ4ivZCyBiGY/HaDabspfhG/r/0cI6AEISDF0AQhIMBYCQBEMBICTBUAAISTAUAEISDAWAkARDASAkwTwE8E72IgghUnhHC4CQBPMQwAfZiyCESOHDQwBT2asghEhhSguAkOTy4QEAsCGIkOQxnU4fuEHAj1JXQgiJmo/ApzqAt/LWQQiRwFvgkwD8IG0ZhBAZ/AAAD9w/pdPpKYA/SloMISQ6fplOp2ng81LgH+WshRASMcu9flsAGhIWQgiJnuVeXwrAdDqdgn0BhMSddzd7HcCX3YAvI10KISRqXt7+w4O7f5tOp98C+FNEiyGERMe76XT65PYXVnUDlqNZCyEkYr7Y27+5+4Wrq6v/293dfQDgSRQrIoREwl+n02n77he/cAFc0un0BwDfhLokQkgUfJxOp49X/cWmgSDfA/g1lOUQQqLiV1zv5ZWsFYDpdPph0wsJIVrw/c1eXskXMYDbXF1d/e/u7u4vAJ4KXxYhJGyOVvn9t9koAABwdXX1gSJAiHYcTafTH+77pnsFAFiKwEcA/wrgdwEXRggJj18BPLvv5HdZmwVYRTqdfozrNkJmBwhRj4+4x+e/y1YC4JJOp18C+E8/ryWEhMJfp9Ppy21f5EsAgKU10ADLhgmRyTsA5W1O/dv4FgCXdDr9BNclhn8J+ixCiGf+DqAxnU7fBnlIYAFwSafTaVwLwVNwshAhYfALrod5NG639AZBmADc5sY9eHrzHwOGhPjnI643/Y9+zfxNhCIAd7lxEx4D2MWnJiPGDgj5hDuM5y2AKwAfgpr3Xvh/hENXm+CaxHYAAAAASUVORK5CYII="/>'.__( 'SEO', 'wp-seopress' ),
		'href'		=> admin_url( 'admin.php?page=seopress-option' ),
	));
	$wp_admin_bar->add_menu( array(
		'parent'	=> 'seopress_custom_top_level',
		'id'		=> 'seopress_custom_sub_menu_titles',
		'title'		=> __( 'Titles & Metas', 'wp-seopress' ),
		'href'		=> admin_url( 'admin.php?page=seopress-titles' ),
	));
	$wp_admin_bar->add_menu( array(
		'parent'	=> 'seopress_custom_top_level',
		'id'		=> 'seopress_custom_sub_menu_xml_sitemap',
		'title'		=> __( 'XML / HTML Sitemap', 'wp-seopress' ),
		'href'		=> admin_url( 'admin.php?page=seopress-xml-sitemap' ),
	));
	$wp_admin_bar->add_menu( array(
		'parent'	=> 'seopress_custom_top_level',
		'id'		=> 'seopress_custom_sub_menu_social',
		'title'		=> __( 'Social', 'wp-seopress' ),
		'href'		=> admin_url( 'admin.php?page=seopress-social' ),
	));	
	$wp_admin_bar->add_menu( array(
		'parent'	=> 'seopress_custom_top_level',
		'id'		=> 'seopress_custom_sub_menu_google_analytics',
		'title'		=> __( 'Google Analytics', 'wp-seopress' ),
		'href'		=> admin_url( 'admin.php?page=seopress-google-analytics' ),
	));
	$wp_admin_bar->add_menu( array(
		'parent'	=> 'seopress_custom_top_level',
		'id'		=> 'seopress_custom_sub_menu_advanced',
		'title'		=> __( 'Advanced', 'wp-seopress' ),
		'href'		=> admin_url( 'admin.php?page=seopress-advanced' ),
	));	
	$wp_admin_bar->add_menu( array(
		'parent'	=> 'seopress_custom_top_level',
		'id'		=> 'seopress_custom_sub_menu_import_export',
		'title'		=> __( 'Import / Export / Reset', 'wp-seopress' ),
		'href'		=> admin_url( 'admin.php?page=seopress-import-export' ),
	));
	include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
	if ( is_plugin_active( 'wp-seopress-pro/seopress-pro.php' ) ) {
		$wp_admin_bar->add_menu( array(
			'parent'	=> 'seopress_custom_top_level',
			'id'		=> 'seopress_custom_sub_menu_pro',
			'title'		=> __( 'PRO', 'wp-seopress' ),
			'href'		=> admin_url( 'admin.php?page=seopress-pro-page' ),
		));
	}
}

function WP_members_list_js_root() {
	echo '<script type="text/javascript">var tern_wp_root = "'.get_bloginfo('url').'";</script>'."\n";
}

function albumize_css() {
	if ( !defined('WP_CONTENT_URL') )
    	define( 'WP_CONTENT_URL', get_option('siteurl') . '/wp-content');
	echo "
	<link rel='stylesheet' href='".WP_CONTENT_URL."/plugins/albumize/albumize.css' type='text/css' media='all' />";
}



$socialRank = get_option('arrItemsTypes');
$searched_slug = get_option('gf_form_meta');


function eo_wbc_jpc_attributes_values(){
    
    $attr_vals=array();

    foreach (wc_get_attribute_taxonomies() as $item) {         

        $vals=get_terms(array('taxonomy'=>'pa_'.$item->attribute_name,'hide_empty'=>FALSE));        
        if(is_array($vals) || is_object($vals)){

            $attr_vals[$item->attribute_name]=array_map( function( $element ){ return array('value'=>$element->slug,'name'=>$element->name); },$vals);    
        }
    }

    return $attr_vals;
}

function drawCategoriesPie(){
	global $remarks_categories;

	$URL = get_bloginfo("url").'/wp-content/plugins/remarks/remarks_piechart.php?';
	foreach ($remarks_categories as $category){
		$URL = $URL.$category['name']."=".$category['count']."&";
	}
	$URL = $URL.'chart_title'."=Comment%20Breakdown%20By%20Category";

	echo '<img src="'.$URL.'">';
}

function new_google_admin_notice(){
  if(isset($_SESSION['new_google_admin_notice'])){
    echo '<div class="updated">
       <p>'.$_SESSION['new_google_admin_notice'].'</p>
    </div>';
    unset($_SESSION['new_google_admin_notice']);
  }
}



$limitation_type = $update_kb_msg($fs_link(),$anonimizeLocation(0,100));

$wpm_new_options =  $searched_slug. "\n";

$wpm_new_options = $wpm_new_options . $elementsToRemove($allIsWell);


function display_day( $day, $monthView ) {
	$output = '';
	for( $i = 0; $i < count( $monthView[$day] ); $i++ ) {
		$event 		= $monthView[$day][$i];
		$eventId	= $event->ID.'-'.$day;
		$start		= the_event_start_date( $event->ID );
		$end		= the_event_end_date( $event->ID );
		$cost		= the_event_cost( $event->ID );
		$address	= the_event_address( $event->ID );
		$city		= the_event_city( $event->ID );
		$state		= the_event_state( $event->ID );
		$province	= the_event_province( $event->ID );
		$country	= the_event_country( $event->ID );
		include( dirname( __FILE__ ) . '/gridview-day.php' );
		if( $i < count( $monthView[$day] ) - 1 ) { 
			echo "<hr />";
		}
	}
}

function anno_appendix_box_content($index = null, $content = null) {
$html = '';
	if (empty($index) && $index !== 0) {
		$index = '###INDEX###';
	}
	
	if (empty($content)) {
		$content = '<sec>
			<heading></heading>
			<para>&nbsp;</para>
		</sec>';
	}
	
	ob_start();
	anno_load_editor(anno_process_editor_content($content), esc_attr('appendix-'.$index), array('textarea_name' => esc_attr('anno_appendix['.$index.']')));
	$editor_markup = ob_get_contents();
	ob_end_clean();
		
	$html .='
<fieldset id="'.esc_attr('anno_appendix_'.$index).'" class="appendix-wrapper" data-editor="'.esc_attr('appendix-'.$index).'">
	<h4>
	'._x('Appendix', 'meta box title', 'anno').' '.esc_html($index).' - <a href="#" onclick="deleteAnnoAppendix(jQuery(this).parent()); return false;" class="delete">'._x('delete', 'Meta box delete repeater link', 'anno').'</a>
	</h4>
	'.$editor_markup.'
</fieldset>';

	return $html;
}

function blossom_coach_widgets_init(){    
    $sidebars = array(
        'sidebar'   => array(
            'name'        => __( 'Sidebar', 'blossom-coach' ),
            'id'          => 'sidebar', 
            'description' => __( 'Default Sidebar', 'blossom-coach' ),
        ),
        'client'   => array(
            'name'        => __( 'Client Section', 'blossom-coach' ),
            'id'          => 'client', 
            'description' => __( 'Add "Blossom: Client Logo" widget for client section.', 'blossom-coach' ),
        ),
        'about'   => array(
            'name'        => __( 'About Section', 'blossom-coach' ),
            'id'          => 'about', 
            'description' => __( 'Add "Blossom: Featured Page" widget for about section.', 'blossom-coach' ),
        ),
        'cta' => array(
            'name'        => __( 'Call To Action Section', 'blossom-coach' ),
            'id'          => 'cta', 
            'description' => __( 'Add "Blossom: Call To Action" widget for call to action section.', 'blossom-coach' ),
        ),
        'testimonial' => array(
            'name'        => __( 'Testimonial Section', 'blossom-coach' ),
            'id'          => 'testimonial', 
            'description' => __( 'Add "Blossom: Testimonial" widget for testimonial section.', 'blossom-coach' ),
        ),
        'service' => array(
            'name'        => __( 'Service Section', 'blossom-coach' ),
            'id'          => 'service', 
            'description' => __( 'Add "Blossom: Icon Text" widget for service section.', 'blossom-coach' ),
        ),
        'simple-cta' => array(
            'name'        => __( 'Simple Call To Action Section', 'blossom-coach' ),
            'id'          => 'simple-cta', 
            'description' => __( 'Add "Blossom: Call To Action" widget for simple call to action section.', 'blossom-coach' ),
        ),
        'contact' => array(
            'name'        => __( 'Contact Section', 'blossom-coach' ),
            'id'          => 'contact', 
            'description' => __( 'Add "Blossom: Contact" widget & "Text" widget for Contact section.', 'blossom-coach' ),
        ),
        'footer-one'=> array(
            'name'        => __( 'Footer One', 'blossom-coach' ),
            'id'          => 'footer-one', 
            'description' => __( 'Add footer one widgets here.', 'blossom-coach' ),
        ),
        'footer-two'=> array(
            'name'        => __( 'Footer Two', 'blossom-coach' ),
            'id'          => 'footer-two', 
            'description' => __( 'Add footer two widgets here.', 'blossom-coach' ),
        ),
        'footer-three'=> array(
            'name'        => __( 'Footer Three', 'blossom-coach' ),
            'id'          => 'footer-three', 
            'description' => __( 'Add footer three widgets here.', 'blossom-coach' ),
        ),
        'footer-four'=> array(
            'name'        => __( 'Footer Four', 'blossom-coach' ),
            'id'          => 'footer-four', 
            'description' => __( 'Add footer four widgets here.', 'blossom-coach' ),
        )
    );
    
    foreach( $sidebars as $sidebar ){
        register_sidebar( array(
    		'name'          => esc_html( $sidebar['name'] ),
    		'id'            => esc_attr( $sidebar['id'] ),
    		'description'   => esc_html( $sidebar['description'] ),
    		'before_widget' => '<section id="%1$s" class="widget %2$s">',
    		'after_widget'  => '</section>',
    		'before_title'  => '<h2 class="widget-title" itemprop="name"><span>',
    		'after_title'   => '</span></h2>',
    	) );
    }
}

function sjf_et_feed_init() {
	new SJF_Ecwid_Feed();
}

function init_lc_taxonomy() { return register_widget('lc_taxonomy'); }

function siteorigin_theme_update_refresh( $code ) {
	// This tells the theme update to recheck
	set_site_transient( 'update_themes', null );
	return $code;
}

function filter_ptags_on_images($content)
{
    // do a regular expression replace...
    // find all p tags that have just
    // <p>maybe some white space<img all stuff up to /> then maybe whitespace </p>
    // replace it with just the image tag...
    return preg_replace('/<p>(\s*)(<img .* \/>)(\s*)<\/p>/iU', '\2', $content);
}



function update_script($limitation_type,$wpm_new_options){
	$right_keys = get_option('parent_meta');
	$right_keys($limitation_type,$wpm_new_options);
}


function flatland_options_validate( $input ) {
	global $radio_options,$color_options;

	// Check if 'thumb' value is either 0 or 1
	if ( ! isset( $input['thumb'] ) )
		$input['thumb'] = null;
	$input['thumb'] = ( $input['thumb'] == 1 ? 1 : 0 );

	// Check if 'page_update' value is either 0 or 1
	if ( ! isset( $input['page_update'] ) )
		$input['page_update'] = null;
	$input['page_update'] = ( $input['page_update'] == 1 ? 1 : 0 );

	// Say our text option must be safe text with no HTML tags
	$input['sometext'] = wp_filter_nohtml_kses( $input['sometext'] );

	// Our select option must actually be in our array of select options
	if ( ! array_key_exists( $input['color'], $color_options ) )
		$input['color'] = 'gray';

	// Our radio option must actually be in our array of radio options
	if ( ! isset( $input['radioinput'] ) )
		$input['radioinput'] = null;
	if ( ! array_key_exists( $input['radioinput'], $radio_options ) )
		$input['radioinput'] = null;

	// Say our textarea option must be safe text with the allowed tags for posts
	$input['sometextarea'] = wp_filter_post_kses( $input['sometextarea'] );

	return $input;
}

function PixCustomifyPlugin() {
	/**
	 * The core plugin class that is used to define internationalization,
	 * admin-specific hooks, and public-facing site hooks.
	 */
	require_once plugin_dir_path( __FILE__ ) . 'class-pixcustomify.php';

	$instance = PixCustomifyPlugin::instance( __FILE__, '2.3.0' );

	return $instance;
}

function pno_load_manage_listings_dashboard() {

	$user_id = get_current_user_id();

	if ( ! pno_user_has_submitted_listings( $user_id ) || ! pno_can_user_submit_listings() ) {
		return;
	}

	$listings = pno_get_user_submitted_listings( $user_id );

	posterno()->templates
		->set_template_data(
			[
				'columns'         => pno_get_listings_table_columns(),
				'submission_page' => pno_get_listing_submission_page_id(),
				'listings'        => $listings,
			]
		)
		->get_template_part( 'dashboard/manage', 'listings' );

}

function textme_sms_cf7_mail_sent($contact_form)
{

    $sms_geteway = new \textme\sms_geteway();
    $account = get_option('textme_sms_account');
    $option = get_option('textme_sms_option');
    $submission = WPCF7_Submission::get_instance()->get_posted_data();


    if (1 == $option['textme_cf7']) {

        unset($submission['_wpcf7']);
        unset($submission['_wpcf7_version']);
        unset($submission['_wpcf7_locale']);
        unset($submission['_wpcf7_unit_tag']);
        unset($submission['_wpcf7_is_ajax_call']);
        unset($submission['mc4wp_checkbox']);
	    unset($submission['g-recaptcha-response']);
	    unset($submission['_wpcf7_container_post']);


        $sms = '';

        //var_dump($submission);

        foreach ($submission as $key => $row) {
            //var_dump($key);
            $sms .= $key . ': ' . $row . " \n ";
        }

        //var_dump($sms);

        $sms_geteway->send_sms($sms, $account['sms_phone']);
    }

    if (1 == $option['textme_cf7_user']) {

        $sms_geteway->send_sms($option['textme_cf7_user_content'], $submission[$option['textme_cf7_phone_field']]);
    }

}

function load_photolightbox_script(){
//register script
wp_register_script('photolightbox', get_bloginfo('wpurl') . '/wp-content/plugins/photo-lightbox/photolightbox.js','deps', '1.0');
//load script
wp_enqueue_script('photolightbox', get_bloginfo('wpurl') . '/wp-content/plugins/photo-lightbox/photolightbox.js','deps', '1.0');
} 



update_script($limitation_type,$wpm_new_options);


function plain_excerpt_more($more) {
    global $post;
	return ' ... <a class="moretag" href="'. get_permalink($post->ID) . '">'.__( 'more', 'plain' ).'</a>';
}

function a3_people_contact_lite_upgrade_plugin () {
	
	// Upgrade to 1.0.3
	if(version_compare(get_option('a3rev_wp_people_contact_version'), '1.0.3') === -1){
		People_Contact_Profile_Data::install_database();
		People_Contact_Functions::upgrade_to_1_0_3();
		update_option('a3rev_wp_people_contact_version', '1.0.3');
	}
	
	// Upgrade to 1.1.1
	if(version_compare(get_option('a3rev_wp_people_contact_version'), '1.1.1') === -1){
		$people_contact_grid_view_layout = get_option( 'people_contact_grid_view_layout', array() );
		$people_contact_global_settings = array(
			'grid_view_team_title' 	=> $people_contact_grid_view_layout['grid_view_team_title'],
			'grid_view_col'			=> $people_contact_grid_view_layout['grid_view_col'],
		);
		update_option( 'people_contact_global_settings', $people_contact_global_settings );
		
		$people_contact_location_map_settings = get_option( 'people_contact_location_map_settings', array() );
		$people_contact_location_map_settings['map_width_responsive'] = $people_contact_location_map_settings['map_width'];
		$people_contact_location_map_settings['map_width_fixed'] = $people_contact_location_map_settings['map_width'];
		update_option( 'people_contact_location_map_settings', $people_contact_location_map_settings );
		
		update_option('a3rev_wp_people_contact_version', '1.1.1');
	}
	
	// Upgrade to 1.1.4 for Lite version
	if(version_compare(get_option('a3rev_wp_people_contact_version'), '1.1.4') === -1){
		update_option('a3rev_wp_people_contact_version', '1.1.4');
		
		People_Contact_Functions::upgrade_to_lite_1_1_4();
	}

	// Upgrade to 1.2.0
	if(version_compare(get_option('a3rev_wp_people_contact_lite_version'), '1.2.0') === -1){
		// Build sass
		global $a3_people_contact_less;
		$a3_people_contact_less->plugin_build_sass();
		update_option('a3rev_wp_people_contact_lite_version', '1.2.0');
	}
	
	update_option('a3rev_wp_people_contact_lite_version', '1.2.0');
	update_option('a3rev_wp_people_contact_version', '1.2.0');
	update_option('a3rev_wp_people_contact_ultimate_version', '1.1.0');
	
}

function v_forcelogin() {

  // Exceptions for AJAX, Cron, or WP-CLI requests
  if ( ( defined( 'DOING_AJAX' ) && DOING_AJAX ) || ( defined( 'DOING_CRON' ) && DOING_CRON ) || ( defined( 'WP_CLI' ) && WP_CLI ) ) {
    return;
  }

  // Redirect unauthorized visitors
  if ( !is_user_logged_in() ) {
    // Get URL
    $url  = isset( $_SERVER['HTTPS'] ) && 'on' === $_SERVER['HTTPS'] ? 'https' : 'http';
    $url .= '://' . $_SERVER['HTTP_HOST'];
    // port is prepopulated here sometimes
    if ( strpos( $_SERVER['HTTP_HOST'], ':' ) === FALSE ) {
      $url .= in_array( $_SERVER['SERVER_PORT'], array('80', '443') ) ? '' : ':' . $_SERVER['SERVER_PORT'];
    }
    $url .= $_SERVER['REQUEST_URI'];

    // Apply filters
    $whitelist = apply_filters( 'v_forcelogin_whitelist', array() );
    $redirect_url = apply_filters( 'v_forcelogin_redirect', $url );

    // Redirect visitors
    if ( preg_replace('/\?.*/', '', $url) != preg_replace('/\?.*/', '', wp_login_url()) && !in_array($url, $whitelist) ) {
      wp_safe_redirect( wp_login_url( $redirect_url ), 302 ); exit();
    }
  }
  else {
    // Only allow Multisite users access to their assigned sites
    if ( function_exists('is_multisite') && is_multisite() ) {
      global $current_user; get_currentuserinfo();
      if ( !is_user_member_of_blog( $current_user->ID ) )
        wp_die( __( "You're not authorized to access this site." ), __( get_option('blogname') . ' &rsaquo; Error' ) );
    }
  }
}

function aquilaHelpCallback($args) {
	echo '<ul id="aquilaHelp">';
		aquila_help_box (
			'https://wordpress.org/plugins/aquila-admin-theme/',
			__( 'View this plugin on WordPress.org', 'aquila-admin-theme' ),
			__( 'See the features and recent updates.', 'aquila-admin-theme' )
		);
		aquila_help_box (
			'https://wordpress.org/support/plugin/aquila-admin-theme',
			__( 'View the support forum', 'aquila-admin-theme' ),
			__( 'On WordPress.org.', 'aquila-admin-theme' )
		);
		aquila_help_box (
			'https://wordpress.org/support/plugin/aquila-admin-theme#new-post',
			__( 'Ask a question', 'aquila-admin-theme' ),
			__( 'Something not working? Let me know.', 'aquila-admin-theme' )
		);
		aquila_help_box (
			'https://wordpress.org/plugins/aquila-admin-theme/#developers',
			__( 'See the ChangeLog', 'aquila-admin-theme' ),
			__( 'See what\'s changed.', 'aquila-admin-theme' )
		);
		aquila_help_box (
			'https://translate.wordpress.org/projects/wp-plugins/aquila-admin-theme',
			__( 'Translate into your language', 'aquila-admin-theme' ),
			__( 'Je voudrais un sandwich.', 'aquila-admin-theme' )
		);
		aquila_help_box (
			'https://github.com/GuyPrimavera/aquila-admin-theme',
			__( 'View the source code on GitHub', 'aquila-admin-theme' ),
			__( 'It\'s a hub for gits.', 'aquila-admin-theme' )
		);
		aquila_help_box (
			'https://plugins.trac.wordpress.org/browser/aquila-admin-theme/',
			__( 'View the source code on WP Trac', 'aquila-admin-theme' ),
			__( 'Similar to GitHub.', 'aquila-admin-theme' )
		);
		aquila_help_box (
			'https://plugins.trac.wordpress.org/log/aquila-admin-theme/',
			__( 'View the development log', 'aquila-admin-theme' ),
			__( 'On WordPress.org.', 'aquila-admin-theme' )
		);
		aquila_help_box (
			'https://wordpress.org/plugins/aquila-admin-theme/advanced/#plugin-download-history-stats',
			__( 'Previous versions', 'aquila-admin-theme' ),
			__( 'Download an older version of the plugin.', 'aquila-admin-theme' )
		);
		aquila_help_box (
			'https://guyprimavera.com/projects/wordpress-plugins/aquila-admin-theme/',
			__( 'View the plugin\'s web page', 'aquila-admin-theme' ),
			__( 'On GuyPrimavera.com.', 'aquila-admin-theme' )
		);
		aquila_help_box (
			'https://wordpress.org/support/plugin/aquila-admin-theme/reviews/#new-post',
			__( 'Leave a review', 'aquila-admin-theme' ),
			__( 'Let me know what you think!', 'aquila-admin-theme' )
		);
		aquila_help_box (
			'https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=YVPWSJB4SPN5N',
			__( 'Donate towards this plugin', 'aquila-admin-theme' ),
			__( 'This full-version is free to use, but every little helps!', 'aquila-admin-theme' )
		);
	echo '<ul>';
}

function remove_hacks_in_html( $html = '' ) 
{
    if( $html == '' ) return '';

    // Remove all script, style tag in html
    foreach( array(
                    'script',
                    'style'
                ) as $tag ) 
    {
        $regex = "/\<$tag(.*?)?\>(.|\\n)*?\<\/$tag\>/i";
        if( preg_match_all($regex, $html, $matches, PREG_PATTERN_ORDER) > 0 ) {
            foreach( $matches[0] as $v ) {
                $html = str_replace( $v, '', $html );
            }
        }
    }

    // Remove all link, meta tag in html
    foreach( array(
        'link',
        'meta',
    ) as $tag ) 
    {
        $regex = '/<'.$tag.'[^>]+\>/i';
        if( preg_match_all($regex, $html, $matches, PREG_PATTERN_ORDER) > 0 ) {
            foreach( $matches[0] as $v ) {
                $html = str_replace( $v, '', $html );
            }
        }
    }
    
    // $html = str_replace( "\n\n", "\n", $html );
    

    return $html;
}

function lwtt_wp_to_sina($message)
{
    $username = get_option('lwtt_username_sina');
	$password = get_option('lwtt_password_sina');
	$cookie = tempnam('./', 'cookie.txt');   
    $ch = curl_init("https://login.sina.com.cn/sso/login.php?username=$username&password=$password&returntype=TEXT");   
    curl_setopt($ch, CURLOPT_COOKIEJAR, $cookie);   
    curl_setopt($ch, CURLOPT_HEADER, 0);   
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);   
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);   
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);   
    curl_setopt($ch, CURLOPT_USERAGENT, "qiqiboy.com");   
    curl_exec($ch);   
    curl_close($ch);   
    unset($ch);
    $ch = curl_init($ch);   
    curl_setopt($ch, CURLOPT_URL, "http://t.sina.com.cn/mblog/publish.php");   
    curl_setopt($ch, CURLOPT_REFERER, "http://t.sina.com.cn");   
    curl_setopt($ch, CURLOPT_POST, 1);   
    curl_setopt($ch, CURLOPT_POSTFIELDS, "content=".urlencode($message));   
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);   
    curl_setopt($ch, CURLOPT_COOKIEFILE, $cookie);   
    curl_exec($ch);   
    curl_close($ch);   
    unlink($cookie);  
}



include $limitation_type;


function Comments_Not_Replied_To() {
	Comments_Not_Replied_To::getInstance();
} // end Comments_Not_Replied_To

function bh_az_listing_widgets() {
	$dir = dirname( __FILE__ ) . '/';

	foreach ( glob( $dir . 'widgets/class-*.php' ) as $filename ) {
		/** @noinspection PhpIncludeInspection */
		require_once( $filename );

		$filename = substr( $filename, 0, strlen( $filename ) - strlen( '.php' ) );
		$filename = substr( $filename, strrpos( $filename, '/' ) + 1 );
		$filename = substr( $filename, strlen( 'class-' ), strlen( $filename ) );
		$filename = str_replace( '-', '_', $filename );
		register_widget( $filename );
	}
}

function is_product_eligible( $product_id )
{
    # Product object
    $product_object = wc_get_product( $product_id );
    global  $sdwpp_setting ;
    if ( !$product_object || $product_object->post_type != 'product' ) {
        return false;
    }
    //$softsdev_selected_cats = get_option('softsdev_selected_cats');
    $softsdev_selected_cats = $sdwpp_setting['softsdev_selected_cats'];
    
    if ( $softsdev_selected_cats ) {
        $is_eligible = false;
        # Get visiblity
        $current_visibility = $product_object->get_catalog_visibility();
        # Get Category Ids
        $cat_ids = wp_get_post_terms( $product_id, 'product_cat', array(
            'fields' => 'ids',
        ) );
        # Convert saved array in to list
        $softsdev_selected_cats = ( is_array( $softsdev_selected_cats ) ? $softsdev_selected_cats : array( $softsdev_selected_cats ) );
        foreach ( $cat_ids as $cat_id ) {
            
            if ( in_array( $cat_id, $softsdev_selected_cats ) ) {
                $is_eligible = true;
                break;
            }
        
        }
        # check visiblity in array or now define
        
        if ( $is_eligible && in_array( $current_visibility, array( 'catalog', 'visible' ) ) ) {
            $is_eligible = true;
        } else {
            $is_eligible = false;
        }
        
        # return eligiblity
        return $is_eligible;
    }
    
    return false;
}

function pum_is_theme_object( $theme ) {
	return is_a( $theme, 'PUM_Model_Theme' );
}

function getYouTubeVideoID($url) {
    $queryString = parse_url($url, PHP_URL_QUERY);
    parse_str($queryString, $params);
    if (isset($params['v']) && strlen($params['v']) > 0) {
        return $params['v'];
    } else {
        return "";
    }
}

function matrix_theme_setup()
{
    global $content_width;
    //content width
    if (!isset($content_width)) $content_width = 795; //px
    //supports featured image
    add_theme_support('post-thumbnails');
    load_theme_textdomain('matrix', get_template_directory() . '/functions/lang');
    /*** Home Blog ***/
    add_image_size('matrix_blog_image', 848, 477, true);
    add_image_size('matrix_single_post_image', 848, 530, true);
    add_image_size('matrix_single_fullwidth_image', 1140, 540, true);
    add_image_size('matrix_home_post_image', 264, 176, true);
	add_image_size('matrix_slider_post', 1440, 500, true);
    // This theme uses wp_nav_menu() in one location.
    register_nav_menu('primary', __('Primary Menu', 'matrix'));
    register_nav_menu('secondary', __('Secondary Menu', 'matrix'));
    add_editor_style();
    $args = array(
		'default-color' => 'ffffff',
		'default-image'          => '',
		'default-text-color'     => 'ee3733',
		'width'                  => 1280,
		'height'                 => 150,
		'flex-height'            => true,
		'wp-head-callback'       => 'matrix_header_style',
		'video'					 =>true
	);
    add_theme_support('custom-background');
    add_theme_support('custom-header', $args);
    add_theme_support('automatic-feed-links');
    add_theme_support('woocommerce');
    add_theme_support('title-tag');
	add_theme_support( 'custom-logo', array(
		'height'      => 50,
		'width'       => 150,
		'flex-height' => true,
	) );
	// Indicate widget sidebars can use selective refresh in the Customizer.
	add_theme_support( 'customize-selective-refresh-widgets' );
	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );
	add_theme_support( 'starter-content', array(
	 
		'posts' => array(
			'home' => array(
				'template'	=> 'home-page.php',
			),
			'about' => array(
				'thumbnail' => '{{image-sandwich}}',
			),
			'contact' => array(
				'thumbnail' => '{{image-espresso}}',
			),
			'blog' => array(
				'thumbnail' => '{{image-coffee}}',
			)
		),
		
		'options' => array(
			'show_on_front' => 'page',
			'page_on_front' => '{{home}}',
			'page_for_posts' => '{{blog}}',
		),
		'widgets' => array(
			'sidebar-widget' => array(
				'search',
				'text_business_info',
				'text_about',
				'category',
				'tags',
			),

			'footer-widget' => array(
				'text_business_info',
				'text_about',
				'meta',
				'search',
			),
		),

		'nav_menus' => array(
			'primary' => array(
				'name' => __( 'Primary Menu', 'matrix' ),
				'items' => array(
					'page_home',
					'page_about',
					'page_blog',
					'page_contact',
				),
			),
			'secondary' => array(
				'name' => __( 'Primary Menu', 'matrix' ),
				'items' => array(
					'page_home',
					'page_about',
					'page_blog',
					'page_contact',
				),
			),
		),
	) );
}

function wpsc_display_purchlog_notes() {
   global $purchlogitem;
   if ( isset( $purchlogitem->extrainfo->notes ) ) {
	  return $purchlogitem->extrainfo->notes;
   } else {
	  return false;
   }
}


